#ifndef MOTOR_H
#define MOTOR_H

typedef	enum{//MotorErrorState	
	Clear =					0, 			
	OverVbus =				1, 			
	UnderVbus =				2, 			
	OverTemperature =		4, 			
	FaultLock =				8, 			
	AOCP =					16, 		
	POCP =					32,			
	LPP = 					64
}ErrorStatus;

enum MotorStatus{//MotorState
	M_OFF =					0, 
	M_INIT = 				1, 
	M_TAILWIND =			2, 
	M_IPD =					3,
	M_Parking =				4,
	M_START =				5,
	M_RUN = 				6, 
	M_STOP = 				7, 
	M_ERROR =				8,
	M_BMF_BREAK =			9,
	M_ADC_INIT =			10
};
//*******************************************************************************************************************************************
// <<< Use Configuration Wizard in Context Menu >>>
// <h> F򥻰Ѽ
	//<o> Stator Line-Line Resistance ( unit : m[)
		#define RS (float)5150/1000			// phase - com - phase

	//<o> Stator Line-Line Inductance ( unit : uH )
		#define LS (float)4820/1000000		// phase - com - phase
	
	//<o> Motor Pole <0-30:2>
		#define POLE 8
		#define POLE_PAIRS  POLE / 2
	
	//<o> PWM_Frequency (unit : Hz) <11724-60000>
	//<i> Limit : 11724Hz - 60000Hz
		#define PWM_Frequency 16000
		#define MPWMDATA_REGS (uint16) ((48000000/PWM_Frequency)/2)

	//<o.4..5> OPA GAIN <0=> 1 Gain <1=> 2.5 Gain <2=> 5 Gain <3=> 10 Gain
		#define OPA_GAIN_REGS 0x20
		#if (OPA_GAIN_REGS == 0x00)
			#define OPA_GAIN 	1
		#endif
		#if (OPA_GAIN_REGS == 0x10)
			#define OPA_GAIN (float)25/10 
		#endif
		#if (OPA_GAIN_REGS == 0x20)
			#define OPA_GAIN 	5
		#endif
		#if (OPA_GAIN_REGS == 0x30)
			#define OPA_GAIN  10
		#endif
		
	//<o> Rshunt (unit : 0.1mR)
		#define R_SHUNT (float)1000/10000 
		#define I_AMPLIFIER (uint16)((float)((((R_SHUNT) * (OPA_GAIN) * 1023))/5)*64)

	//<o> Motor rated maximum speed ( unit : RPM )
		#define RATED_SPEED 1500
		#define RATED_SPEEDMAX (float)(RATED_SPEED * POLE_PAIRS)
	
	//<o> DC bus Voltage ( unit : V )
		#define VBUS 24
	
	//<o> Watt Maximum ( unit : mW )
	//<i>(Rated current = (Watt Maximum / VBUS))
		#define WATT_MAX 15000
// </h>

// <h> Ұʬ
	// <e> IPDҰ
	#define IPD_FUNCTION 0
		
		// <h> IPD LEVEL
			// <o.0..2> I_SHORT <0=> 0.15V <1=> 0.2V <2=> 0.25V <3=> 0.3V <4=> 0.35V <5=> 0.4V <6=> 0.45V <7=> 0.5V
			// <i> GIPD nqy
			// <o.6> AOCPEN <0=> Disable <1=> Enable 
			// <o.7> DOCPEN <0=> Disable <1=> Enable 
			// <o.4> IPD Path Select <0=> IPD Current Compare from AOCP Path <1=> IPD Current Compare from OPA Path
			#define IPD_LEVEL 0x40
		// </h>
		
		// <h> IPD IAECYC
			// <o.1..2> IAECYC <0=> 48MHz <1=> 24MHz <2=> 12MHz <3=> 6MHz 
			#define IAECYC 0x04
		// </h>
	// </e>
	
	// <e> SQUARE_PARKING
	#define SQUARE_PARKING 0
	// <o> Set Square parking time(unit : ms)
	#define SQUARE_PARKING_TIME 1000
	// <o> Set Square parking initial duty(0~32767)
	#define SQUARE_PARKING_INI_DUTY 100
	// <o> Set Square parking end duty(0~32767)
	#define SQUARE_PARKING_END_DUTY 150

	#define SQUARE_PARKING_RANK 20
	#define SQUARE_PARKING_TIME_STEP (SQUARE_PARKING_TIME/SQUARE_PARKING_RANK)
	#define SQUARE_PARKING_CUR_STEP (float)((SQUARE_PARKING_END_DUTY - SQUARE_PARKING_INI_DUTY)/SQUARE_PARKING_RANK)
	
	// <o> Set parking phase <0=> UH_VL <1=> UH_WL <2=> VH_WL <3=> VH_UL <4=> WH_UL <5=> WH_VL
	// <i> pG"IPDҰ"Aparking phaseIPD槹tδѡABܴNL!!
	// <i> CW:U_V_WMCU:U_V_WFCCW:U_V_WMCU:V_U_W
	#define PARKINH_PHASE 1

	#define MOTOR_LOCK_TIME 200
	#define IPDAdvanceAng 8
	// </e>

	// <h> f
		// <o> Set the judgment counter for the static BEMF value of the motor
				#define dMotor_standstill_judgment_cnt	300
	
		// <e> BEMF Fairwind/Headwind judgment (resistance) Enable/Disable
		#define BEMF_TAILWIND_RES_FUNCTION 1

			#if (BEMF_TAILWIND_RES_FUNCTION == 1)
			// <o> BEMF Fairwind/Headwind adjustment process <1=> LEVEL 1 <2=> LEVEL 2
			// <i> LEVEL_1 : Not executed MOTOR_Start_Fun, Stop the program to TailWindDetect_Fun, TailWindDetect_Bemf_Fun, TailWindDetect_OneBemf_Fun, TailWindDetect_TwoBemf_Fun 
			// <i> LEVEL_2 : execute program
			#define BEMF_TAILWIND_SOP 2
					
			// <h> Set BEMF A/D Channel
				// <o> Set BEMF_V_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
				#define BEMF_V_CH 4
							
				// <o> Set BEMF_W_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
				#define BEMF_W_CH 5
			// </h>
					
			// <h> Set Speed for judging Fairwind/Headwind
				// <o1> Set the minimum connection speed for judging Fairwind	(unit : rpm)
				#define	DET_Tailspeed_min_speed		(short)((long)93750/((50*  (POLE_PAIRS))/60))
							
				// <o1> Set the maximum connection speed for judging Fairwind	(unit : rpm)
				#define	DET_Tailspeed_max_speed		(short)((long)93750/((500* (POLE_PAIRS))/60))	
					
				// <o1> Set the maximum connection speed to judge the headwind	(unit : rpm)	
				#define	DET_Headspeed_max_speed		(short)((long)93750/((100*  (POLE_PAIRS))/60))	//87

				// <o> Set the duration of Fairwind start judgment (unit : ms)
				#define TAILWIND_DURATION 50 
			// </h>

				// <o> Set Headwind_high_speed_start_Strategy <1=>PLL <2=>ABS
				#define Headwind_High_Speed_Start_Strategy 2

				// <o> Set Fairwind/Headwind angle(CW_CCW=0) <0-383>
				// <i> 0~383 = 0~360 degrees
				#define CW_TAILWIND_RES_ANG 	0

				// <o> Set Fairwind/Headwind angle(CW_CCW=1) <0-383>	
				// <i> 0~383 = 0~360 degrees
				#define CCW_TAILWIND_RES_ANG 	64

				// <o> Set IQ Fairwind/Headwind starting current(IQ_CMD) (unit : mA)
				#define IQ_FINAL_TAILWIND_START (float)500/1000 
				#define IQ_FINAL_TAILWIND_START_VALUE (int16)((float) (IQ_FINAL_TAILWIND_START) * (I_AMPLIFIER)) // unit : A * Gain

				// <o> Set ID Fairwind/Headwind starting current(ID_CMD) (unit : mA)
				#define ID_FINAL_TAILWIND_START (float)0/1000
				#define ID_FINAL_TAILWIND_START_VALUE (int16)((float) -(ID_FINAL_TAILWIND_START) * (I_AMPLIFIER)) // unit : A * Gain

				// <o> Set the initial value of Fairwind/Headwind current(IQ_UI) (unit : Val) <0-60000>
				#define BEMF_TAILWIND_IQ_OUT_VALUE (short)(8000)

				// <o> Set Headwind to Fairwind target speed (unit : rpm) <0-60000>
				// <i>	Determine the target speed from headwind to Fairwind
				#define BEMF_TAILWIND_SPEED_VALUE (short)((float) 30 * 32767 / (BASE_RPM))
			#endif
		// </e>
		
		// <e> BEMF Fairwind/Headwind judgment (Diode) Enable/Disable
		// <i> Note: Requires Enable brake control function
		#define BEMF_TAILWIND_DIODE_FUNCTION 0

			#if (BEMF_TAILWIND_DIODE_FUNCTION == 1)	
			// <o> BEMF Fairwind/Headwind adjustment process <1=> LEVEL 1 <2=> LEVEL 2
			// <i> LEVEL_1 : Not executed MOTOR_Start_Fun, Stop the program to TailWindDetect_Fun, TailWindDetect_Bemf_Fun, TailWindDetect_OneBemf_Fun, TailWindDetect_TwoBemf_Fun 
			// <i> LEVEL_2 : execute program
			#define BEMF_TAILWIND_SOP 2

			// <h> Set BEMF A/D Channel	
				// <o> Set BEMF_V_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
				#define BEMF_V_CH 4

				// <o> Set BEMF_W_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
				#define BEMF_W_CH 5	
			// </h>

			// <h> Set Speed for judging Fairwind/Headwind
				// <o1> Set the minimum connection speed for judging Fairwind	(unit : rpm)
				#define	DET_Tailspeed_min_speed		(short)((long)93750/((23*  (POLE_PAIRS))/60))

				// <o1> Set the maximum connection speed for judging Fairwind	(unit : rpm)
				#define	DET_Tailspeed_max_speed		(short)((long)93750/((140* (POLE_PAIRS))/60))	

				// <o1> Set the maximum connection speed to judge the headwind	(unit : rpm)	
				#define	DET_Headspeed_max_speed		(short)((long)93750/((100*  (POLE_PAIRS))/60))	//87

				// <o> Set the duration of Fairwind start judgment (unit : ms)
				#define TAILWIND_DURATION 100 
			// </h>

			// <o> Set Fairwind/Headwind angle(CW_CCW=0) <0-383>
			// <i> 0~383 = 0~360 degrees
			#define CW_TAILWIND_DIODE_ANG 	96

			// <o> Set Fairwind/Headwind angle(CW_CCW=1) <0-383>
			// <i> 0~383 = 0~360 degrees
			#define CCW_TAILWIND_DIODE_ANG 	128

			// <o> Set IQ Fairwind/Headwind starting current(IQ_CMD) (unit : mA)
			#define IQ_FINAL_TAILWIND_START (float)2000/1000 
			#define IQ_FINAL_TAILWIND_START_VALUE (int16)((float) (IQ_FINAL_TAILWIND_START) * (I_AMPLIFIER)) // unit : A * Gain

			// <o> Set the initial value of Fairwind/Headwind current(IQ_UI) (unit : Val) <0-60000>
			#define BEMF_TAILWIND_IQ_OUT_VALUE (short)(4000)

			// <o> Set ID Fairwind/Headwind starting current(ID_CMD) (unit : mA)
			#define ID_FINAL_TAILWIND_START (float)0/1000
			#define ID_FINAL_TAILWIND_START_VALUE (int16)((float) -(ID_FINAL_TAILWIND_START) * (I_AMPLIFIER)) // unit : A * Gain

			// <o> Set Headwind to Fairwind target speed (unit : rpm) <0-60000>
			#define BEMF_TAILWIND_SPEED_VALUE (short)((float) 200 * 32767 / (BASE_RPM))
			#endif
		// </e>

		// <e> Fairwind/Headwind judgment (Estimator) Enable/Disable
		#define TAILWIND_ESTIMATED_FUNCTION 0

			#if (TAILWIND_ESTIMATED_FUNCTION == 1)
			// <o> Set Fairwind speed (unit : rpm) <0-1000>
			#define SPEED_TAILWIND_VALUE (short)((float) 20 * 32767 / (BASE_RPM))
					
			// <o> Set Fairwind/Headwind speed (unit : rpm) <0-60000>
			// <i> Description: Set the speed when connected in a Fairwind state
			#define BEMF_TAILWIND_SPEED_VALUE (short)((float) 200 * 32767 / (BASE_RPM))
					
			// <o> BEMF Fairwind/Headwind adjustment process <1=> LEVEL 1 <2=> LEVEL 2
			// <i> LEVEL_1 : Not executed MOTOR_Start_Fun, Stop the program to TailWindDetect_Fun, TailWindDetect_Bemf_Fun, TailWindDetect_OneBemf_Fun, TailWindDetect_TwoBemf_Fun 
			// <i> LEVEL_2 : execute program	
			#define BEMF_TAILWIND_SOP 2
			#endif
		// </e>
		
	#if ((TAILWIND_ESTIMATED_FUNCTION == 0) && (BEMF_TAILWIND_RES_FUNCTION == 0) && (BEMF_TAILWIND_DIODE_FUNCTION == 0))
		#define BEMF_TAILWIND_SPEED_VALUE 0
	#endif
	// </h>
// </h>

// <h> FBҦ
	// <o> Set CW/CCW steering <0=> CW <1=>CCW
	#define CW_CCW 0
		
	// <o> Set Stop_Fun stop speed (unit : rpm)
	// <i> Motor stop output pwm speed
	#define STOP_SPEED_VALUE (short)((float) 30 * 32767 / (BASE_RPM))

	// <e> wqy(Iq)
	#define CURRENT_CONTROL 1
		
		#if (CURRENT_CONTROL == 1)
		// <o> Set current control range(Max) (unit : mA)
		#define IQ_MAX_LIMIT_VALUE (int16)((float) 150/1000 * I_AMPLIFIER) // unit : A * Gain

		// <o> Set current control range(Min) (unit : mA)
		#define IQ_MIN_LIMIT_VALUE (int16)((float) 0/1000 * I_AMPLIFIER) // unit : A * Gain
					
		#define IQ_GAIN ((float) (IQ_MAX_LIMIT_VALUE) / 1023)
					
		// <o> Set CURRENT_RAMP slope (unit : ms)
		#define CURRENT_RAMP		40
					
		// <o> Set CURRENT_CMD accelerate RAMP
		#define CURRENT_ACC			20
					
		// <o> Set CURRENT_CMD decelerate RAMP
		#define CURRENT_DEC			15

		// <e> \v
		#define POWER_LIMIT 0

		#if (POWER_LIMIT == 1)
			// <o> Input power limit (unit : 0.01W) <0-32767>
			// <i>  : Fill in the input Vbus_avg, Ibus_avg multiplied, WATT value
			#define WATT_LIMIT_VALUE (uint32) 240
					
			// <o> Set V_BUS_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
			#define V_BUS_CH 6

			// <o> Set I_BUS_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
			#define I_BUS_CH 2
					
			// <o> Set Power rate parameter (unit : 0.0001)
			#define dPOWER_GAIN ((float) 235/10000)//188
					
		#endif
		// </e>

		#endif
	// </e>
		
	// <e> wt
	#define SPEED_CONTROL 0

		#if (SPEED_CONTROL == 1)
		// <o> Set speed control range(Max) (unit : rpm)
		#define SPEED_MAX_LIMIT_VALUE (short)((float) 400 * 32767 / (BASE_RPM))    // 2960, BASE_RPM = 4095
					
		// <o> Set speed control range(Min) (unit : rpm)
		#define SPEED_MIN_LIMIT_VALUE (short)((float) 100 * 32767 / (BASE_RPM)) 
					
		// <o> Set SPEED_RAMP slope (unit : ms)
		#define SPEED_RAMP		2
					
		// <o> Set SPEED_CMD accelerate RAMP
		#define SPEED_ACC		20
					
		// <o> Set SPEED_CMD decelerate RAMP
		#define SPEED_DEC		15

		// <e> \v
		#define POWER_LIMIT 0

		#if (POWER_LIMIT == 1)
			// <o> Input power limit (unit : 0.01W) <0-32767>
			// <i>  : Fill in the input Vbus_avg, Ibus_avg multiplied, WATT value
			#define WATT_LIMIT_VALUE (uint32) 8000
					
			// <o> Set V_BUS_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
			#define V_BUS_CH 6

			// <o> Set I_BUS_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
			#define I_BUS_CH 2
					
			// <o> Set Power rate parameter (unit : 0.0001)
			#define dPOWER_GAIN ((float) 144/10000)//188
					
		#endif
		// </e>

		#endif
	// </e>

	#if (CURRENT_CONTROL == 1) && (SPEED_CONTROL == 1)
		#error Wrong setting CURRENT_CONTROL and SPEED_CONTROL !!!!
	#endif
// </h>

// <h> P䱱
	// <e> VSP control commands Enable/Disable
	#define VSP_TRI 1

		#if (VSP_TRI == 1)
		// <o> Set VSP_CH <0=> CH0 <1=> CH1 <2=> CH2 <3=> CH3 <4=> CH4 <5=> CH5 <6=> CH6 <7=> CH7 
		#define VSP_CH 7

		// <e> Slope control
		#define dSlope_control 1
			#if (dSlope_control == 1)
			// <o> Set VSP srart voltage (unit : 0.1v)
			#define  CMD_START		(float)5/10
			#define  CMD_START_VAL	(unsigned int)((float)(CMD_START) *1023 / 5.0)

			// <o> Set VSP max voltage (unit : 0.1v)
			#define  CMD_MAX		(float)45/10
			#define  CMD_MAX_VAL	(unsigned int)((float)(CMD_MAX) *1023 / 5.0)

			// <o> Set VSP stop voltage (unit : 0.1v)
			#define  CMD_STOP		(float)3/10
			#define  CMD_STOP_VAL	(unsigned int)((float)(CMD_STOP) *1023 / 5.0)

			#define SPEED_STEP		((unsigned long)1024 * ((SPEED_MAX_LIMIT_VALUE) - (SPEED_MIN_LIMIT_VALUE))) / ((CMD_MAX_VAL) - (CMD_START_VAL))

			#endif
		// </e>
			
		// <e> Stage control
		#define dStage_control 0

			#if (dStage_control == 1)
			// <o> 	Set VSP SPEED1 speed
			#define VSP_SPEED_1					(short)((float) 50 * 32768 / BASE_RPM)

			// <o> Set VSP SPEED2 speed
			#define VSP_SPEED_2					(short)((float) 75 * 32768 / BASE_RPM)

			// <o> Set VSP SPEED3 speed
			#define VSP_SPEED_3					(short)((float) 100 * 32768 / BASE_RPM)

			// <o> Set VSP SPEED4 speed
			#define VSP_SPEED_4					(short)((float) 125 * 32768 / BASE_RPM)

			// <o> Set VSP SPEED4 speed
			#define VSP_SPEED_5 				(short)((float) 180 * 32768 / BASE_RPM)
		
		#endif
		// </e>
				
				#if (dSlope_control == 1) && (dStage_control == 1)
					#error Wrong setting Slope_control and Stage_control !!!!
				#endif
			#endif
		// </e>

		// <e> Break control Enable/Disable
			#define BREAK_FUNCTION 0
			#if (BREAK_FUNCTION == 1)
				// <o> Set braking force (unit : %) <0-100>
				// <i> Description: Set the braking force in the tailwind state
					#define BREAK_DUTY (float)99/100
					#define BREAK_DUTY_VALUE (uint16)((float) (MPWMDATA_REGS) * (BREAK_DUTY))
			#else
				#define BREAK_DUTY (float)99/100
				#define BREAK_DUTY_VALUE (uint16)((float) (MPWMDATA_REGS) * (BREAK_DUTY))
			#endif
		// </e>
		

// </h>	


// <h> Motor state(MotorState)
	// <i>	M_OFF =			0(~ҪA)
	// <i>	M_INIT =		1(lȳ]w)
	// <i>	M_TAILWIND = 	2(f˴)
	// <i>	M_IPD =			3(l˴)
	// <i>  M_Parking =		4(w쵦)
	// <i>	M_START = 		5(FҰʬy{)
	// <i>	M_RUN =			6(i~)
	// <i>	M_STOP =		7(F)
	// <i>	M_ERROR = 		8(~ᤣAҪA)
	// <i>	M_BMF_BREAK =	9(b˴BEMFA)
	// <i>	M_ADC_INIT =	10(եADC)			
// </h>	
// <<< end of configuration section >>>



// PI_GAIN
#define PLLKIGEN 0x01
#define PLLKPGEN 0x02
#define SPEEDKIGEN 0x04
#define SPEEDKPGEN 0x08
#define IDKIGEN 0x10
#define IDKPGEN 0x20
#define IQKIGEN 0x40
#define IQKPGEN 0x80

// PI_TMSR
#define PLLTMEN 0x01
#define PLLTMSEL 0x02
#define SPEEDTMEN 0x04
#define SPEEDTMSEL 0x08
#define IDTMEN 0x10
#define IDTMSEL 0x20
#define IQTMEN 0x40
#define IQTMSEL 0x80


#define USER_FB_MACRO(v) SFR_PAGE = 4; PI_FB = v
#define GET_USER_OUT_MACRO(v) SFR_PAGE = 4; v = PI_OUT

#define IQ_CMD_MACRO(v) SFR_PAGE = 0; PI_CMD = v
#define GET_IQ_OUT_MACRO(v) SFR_PAGE = 0; v = PI_OUT
#define ID_CMD_MACRO(v) SFR_PAGE = 1; PI_CMD = v

#define SPEED_CMD_MACRO(v) SFR_PAGE = 2; PI_CMD = v
#define GET_SPEED_OUT_MACRO(v) SFR_PAGE = 2; v = PI_OUT
#define PLL_CMD_MACRO(v) SFR_PAGE = 3; PI_CMD = v
#define USER_CMD_MACRO(v) SFR_PAGE = 4; PI_CMD = v

#define IQ_KP_MACRO(v) SFR_PAGE = 0; PI_KP = v
#define ID_KP_MACRO(v) SFR_PAGE = 1; PI_KP = v
#define SPEED_KP_MACRO(v) SFR_PAGE = 2; PI_KP = v
#define PLL_KP_MACRO(v) SFR_PAGE = 3; PI_KP = v
#define USER_KP_MACRO(v) SFR_PAGE = 4; PI_KP = v

#define IQ_KI_MACRO(v) SFR_PAGE = 0; PI_KI = v
#define ID_KI_MACRO(v) SFR_PAGE = 1; PI_KI = v
#define SPEED_KI_MACRO(v) SFR_PAGE = 2; PI_KI = v
#define PLL_KI_MACRO(v) SFR_PAGE = 3; PI_KI = v
#define USER_KI_MACRO(v) SFR_PAGE = 4; PI_KI = v

#define IQ_KT_MACRO(v) SFR_PAGE = 0; PI_KT = v
#define ID_KT_MACRO(v) SFR_PAGE = 1; PI_KT = v
#define SPEED_KT_MACRO(v) SFR_PAGE = 2; PI_KT = v
#define PLL_KT_MACRO(v) SFR_PAGE = 3; PI_KT = v
#define USER_KT_MACRO(v) SFR_PAGE = 4; PI_KT = v

#define IQ_TR_MACRO(v) SFR_PAGE = 0; PI_TR = v
#define ID_TR_MACRO(v) SFR_PAGE = 1; PI_TR = v
#define SPEED_TR_MACRO(v) SFR_PAGE = 2; PI_TR = v
#define PLL_TR_MACRO(v) SFR_PAGE = 3; PI_TR = v

#define IQ_UI_MACRO(v) SFR_PAGE = 0; PI_UI = v
#define ID_UI_MACRO(v) SFR_PAGE = 1; PI_UI = v
#define SPEED_UI_MACRO(v) SFR_PAGE = 2; PI_UI = v
#define PLL_UI_MACRO(v) SFR_PAGE = 3; PI_UI = v
#define USER_UI_MACRO(v) SFR_PAGE = 4; PI_UI = v

#define IQ_OUT_MACRO(v) SFR_PAGE = 0; PI_OUT = v
#define ID_OUT_MACRO(v) SFR_PAGE = 1; PI_OUT = v
#define SPEED_OUT_MACRO(v) SFR_PAGE = 2; PI_OUT = v
#define PLL_OUT_MACRO(v) SFR_PAGE = 3; PI_OUT = v
#define USER_OUT_MACRO(v) SFR_PAGE = 4; PI_OUT = v

#define IQ_MAX_MACRO(v) SFR_PAGE = 0; PI_MAX = v
#define ID_MAX_MACRO(v) SFR_PAGE = 1; PI_MAX = v
#define SPEED_MAX_MACRO(v) SFR_PAGE = 2; PI_MAX = v
#define PLL_MAX_MACRO(v) SFR_PAGE = 3; PI_MAX = v
#define USER_MAX_MACRO(v) SFR_PAGE = 4; PI_MAX = v

#define IQ_MIN_MACRO(v) SFR_PAGE = 0; PI_MIN = v
#define ID_MIN_MACRO(v) SFR_PAGE = 1; PI_MIN = v
#define SPEED_MIN_MACRO(v) SFR_PAGE = 2; PI_MIN = v
#define PLL_MIN_MACRO(v) SFR_PAGE = 3; PI_MIN = v
#define USER_MIN_MACRO(v) SFR_PAGE = 4; PI_MIN = v

#define GS_MACRO(v) SFR_PAGE = 0; SMO_D1 = v
#define SMO_KSLIDE_MACRO(v) SFR_PAGE = 1; SMO_D1 = v
#define ANG_BASE_MACRO(v) SFR_PAGE = 2; SMO_D1 = v
#define Z_CORR_MACRO(v) SFR_PAGE = 3; SMO_D1 = v
#define SMO_ANG_MACRO(v) SFR_PAGE = 4; SMO_D1 = v
#define BAN_GAIN_MACRO(v) SFR_PAGE = 5; SMO_D1 = v

#define FS_MACRO(v) SFR_PAGE = 0; SMO_D2 = v
#define SMO_FILTER_MACRO(v) SFR_PAGE = 1; SMO_D2 = v
#define MAXSMC_ERR_MACRO(v) SFR_PAGE = 3; SMO_D2 = v
#define SPEED_MACRO(v) SFR_PAGE = 4; SMO_D2 = v
#define VQ_OFFSET_MACRO(v) SFR_PAGE = 0; FOC_D = v; SYNC = 0x55
#define VD_OFFSET_MACRO(v) SFR_PAGE = 1; FOC_D = v; SYNC = 0x55
#define AS_MACRO(v) SFR_PAGE = 3; FOC_D = v
#define CPU_ANG_MACRO(v) SFR_PAGE = 4; FOC_D = v; SYNC = 0x55
#define FOC_ANG_MACRO(v) SFR_PAGE = 5; FOC_D = v
#define SVPWM_AMP_MACRO(v) SFR_PAGE = 6; FOC_D = v

#define GET_IQ_UI_MACRO(v) SFR_PAGE = 0; v = PI_UI
#define GET_SPEED_UI_MACRO(v) SFR_PAGE = 2; v = PI_UI
#define GET_PLL_UI_MACRO(v) SFR_PAGE = 3; v = PI_UI

#define GET_SPEED_MACRO(v) SFR_PAGE = 4; v = SMO_D2
#define GET_VQ_MACRO(v) SFR_PAGE = 0; v = PI_OUT;
#define GET_PLL_MACRO(v) SFR_PAGE = 3; v = PI_OUT;

#define GET_IQ_MACRO(v) SFR_PAGE = 0; v = PI_FB;

#define IA_AD_OFFSET(v) SFR_PAGE = 0; ADCOS = v
#define IB_AD_OFFSET(v) SFR_PAGE = 1; ADCOS = v


#define FG_ENABLE 				FGCTRL|= (0x80)
#define FG_DISABLE 				FGCTRL&= ~(0x80)

#define	PLL_ENABLE				FOCCONT|= PLLEN
#define	PLL_DISABLE				FOCCONT&= ~(PLLEN)

#define	SPEED_ENABLE			FOCCONT|= SPEEDEN
#define	SPEED_DISABLE			FOCCONT&= ~(SPEEDEN)

#define DUTY_FROM_SVPWM			MOTOR_CONT1|= (MPWMDUSEL)
#define DUTY_FROM_USER			MOTOR_CONT1&= ~(MPWMDUSEL)

#define	USE_SMO_ANG				MOTOR_CONT1|= (FOCANGSEL)
#define	USE_CPU_ANG				MOTOR_CONT1&= ~(FOCANGSEL)

#define	IQ_LOOP_FROM_SPEED_OUT	MOTOR_CONT1|= (IQINSEL)
#define	IQ_LOOP_FROM_IQ_CMD		MOTOR_CONT1&= ~(IQINSEL)

#define	ENABLE_5SVPWM			MOTOR_CONT2|= ~(SVPWMMODE)
#define	ENABLE_7SVPWM			MOTOR_CONT2&= ~(SVPWMMODE)

#define	Direction_CCW			MOTOR_CONT2|= (SVPWMPS)
#define	Direction_CW			MOTOR_CONT2&= ~(SVPWMPS)


#define USER_PI_ACTIVE MOTOR_CONT1 |= 0x04


extern bit MOTOR_PWM_ENABLE;
extern bit MOTOR_OFF_FLAG;
extern xdata uint8  	MotorStartRetryCount;

//extern idata uint8 SpeedNum_temp;
//extern uint8 SpeedNum;
extern int16 SpeedCmd;
extern int16 SpeedCmdTemp;
extern int16 CurrentCmd;
extern int16 CurrentCmdTemp;
extern uint8 MotorDir;

extern uint8 MotorState;
extern uint8 MotorErrorState;
extern uint8 MotorFaultState;

extern uint16 Vbus_avg;
extern uint16 Vbus_avg_old;

extern int16 Ibus_avg;
//extern uint16 VbusOffset;
extern uint16 Vsp_avg;

extern uint16 Temperature_avg;

extern xdata int16 ParkingOutTemp;
extern xdata int16 IqOutTemp;
extern xdata int16 IdOutTemp;
extern xdata int16 PllOutTemp;

extern xdata int16 LatestTheta;
extern xdata uint8 CCWFlag;
extern idata int16 EstimatedSpeed;
//extern xdata uint16 RecHallUEdgeCnt;
//extern xdata uint16 HallUEdgeCnt;

extern xdata uint16 Watt;
//extern xdata signed int	POWER_TARGET_VALUES;
//extern xdata unsigned char	vbus_high_sw;

extern 	xdata int16 BmfVW_Sub;
extern 	xdata uint16 abs_BmfVW_Sub;
extern 	xdata int16 BmfVW_Sum_Pos_ZeroPoint;
extern 	xdata int16 BmfVW_Sum_Neg_ZeroPoint;
extern	xdata uint16 BmfBreakCount;
extern 	xdata int16 BmfU;
extern 	xdata int16 BmfV;
extern 	xdata int16 BmfW;
extern 	xdata int8 ZeroPointCheck;
extern 	xdata int8 ZeroPointDebounceCnt;
extern 	xdata int8 ZeroPointCnt;
extern 	bit ZeroPointFlag;
extern 	bit ZeroPointFlagOld;

extern xdata	uint16	Motor_standstill_judgment_cnt;
	

extern struct{
	//unsigned char IR_Data_Decode_Finish:1;
	//unsigned char IR_Decode_Header:1;
	//unsigned char External1_TRIG:1;
	unsigned char Current_offset:1;			//1 = qyե.	
	unsigned char CloseLoopFlag:1;
	unsigned char ZeroPointFlag:1;
	unsigned char ZeroPointFlagOld:1;
	unsigned char MOTOR_PWM_ENABLE:1;		//1 = PWMX.
	unsigned char MOTOR_OFF_FLAG:1;			//1 = UFFO.
	unsigned char Break_flag:1;
	//unsigned char Counter_Function_sw:1;	//1 = }ҩwɥ\
	//unsigned char Smart_Function_sw:1;		//1 = }SMART\
	//unsigned char RF_Learning_sw:1;			//1 = RFǲߵ
	//unsigned char Buzzer_SW:1;
	//unsigned char Smart_Function_eeprom:1;
	
}FLAG;

//extern	xdata	unsigned int PowerCmd;
extern 	xdata uint16 	IQ_Parking_cnt;
extern	xdata uint16 	RampDelayCount;
extern	xdata uint16 	TailwindCount;
extern	xdata uint16 	TailwindTimeOut;

extern	xdata int8 		AngleStateCehckCount;
extern	xdata uint16 	BreakPwmDuty;
extern	xdata uint16	ABS_break_time;


extern	xdata uint16 	CloseLoopDelayCount;
// Function

//#if (POWER_CONTROL == 1)
//extern xdata signed long Watt_C;
//extern void PowerControl_Fun (void);
//#endif
#if (VSP_TRI == 1)
extern void Vsp_Fun (void);
#endif
#if (BEMF_TAILWIND_RES_FUNCTION == 1) || (BEMF_TAILWIND_DIODE_FUNCTION == 1)
extern void MotorAngle_TwoBEMF_Fun(void);
#endif


extern short Ramp_Fun (short TargetValue,SetpointValue,HighLimit,LowLimit,ADD_SetpValue,SUB_SetpValue);
	
extern void TailWindStart_Fun (void);

extern void IPD_IQ_Initial_Set (void);

extern void Break_Fun (void);
#if(SQUARE_PARKING == 1)
extern void Phase_Duty_Setup(uint8 Phase, uint16 Duty);
#endif

#endif
